/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeBuilder;

public abstract class NetherBiomeConfig {
    public static final SurfaceRules.RuleSource NETHERRACK = SurfaceRules.m_189390_((BlockState)Blocks.f_50134_.m_49966_());
    public static final SurfaceRules.RuleSource BEDROCK_BOTTOM = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)NetherBiomeBuilder.BEDROCK_BOTTOM, (SurfaceRules.RuleSource)NetherBiomeBuilder.BEDROCK);
    public static final SurfaceRules.RuleSource BEDROCK_TOP = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)NetherBiomeBuilder.BEDROCK_TOP), (SurfaceRules.RuleSource)NetherBiomeBuilder.BEDROCK);
    public final ResourceLocation ID;

    protected NetherBiomeConfig(String name) {
        this.ID = BetterNether.makeID(name.replace(' ', '_').toLowerCase());
    }

    public String configGroup() {
        return this.ID.m_135827_() + "." + this.ID.m_135815_();
    }

    public boolean hasVanillaFeatures() {
        return true;
    }

    public boolean hasVanillaOres() {
        return true;
    }

    public boolean hasStalactites() {
        return false;
    }

    public boolean hasDefaultOres() {
        return true;
    }

    public boolean hasNetherCity() {
        return true;
    }

    public boolean hasVanillaStructures() {
        return true;
    }

    public boolean hasBNStructures() {
        return true;
    }

    public boolean hasBNFeatures() {
        return true;
    }

    public <M extends Mob> int spawnWeight(NetherEntities.KnownSpawnTypes type) {
        int res = type.weight;
        switch (type) {
            case JUNGLE_SKELETON: 
            case FLYING_PIG: 
            case HOGLIN: 
            case PIGLIN_BRUTE: {
                res = 0;
            }
        }
        return res;
    }

    protected abstract void addCustomBuildData(BCLBiomeBuilder var1);

    public abstract BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier();

    public SurfaceRuleBuilder surface() {
        return SurfaceRuleBuilder.start().rule(0, BEDROCK_TOP).rule(0, BEDROCK_BOTTOM).rule(10, NETHERRACK);
    }
}

